<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

// Common path to default layout images.
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$url = GENESIS_ADMIN_IMAGES_URL . '/layouts/';

/**
 * The Layouts config. Sets the default layouts for use by Genesis.
 *
 * If child theme contains a `layouts.php` config, it will be used instead of this config.
 *
 * @since 2.8.0
 */
return [
	'content-sidebar'         => [
		'label'   => 'content-sidebar',
		'img'     => $url . 'cs.gif',
		'default' => is_rtl() ? false : true,
		'type'    => [ 'site' ],
	],
	'sidebar-content'         => [
		'label'   => 'sidebar-content',
		'img'     => $url . 'sc.gif',
		'default' => is_rtl() ? true : false,
		'type'    => [ 'site' ],
	],
	'content-sidebar-sidebar' => [
		'label' => 'content-sidebar-sidebar',
		'img'   => $url . 'css.gif',
		'type'  => [ 'site' ],
	],
	'sidebar-sidebar-content' => [
		'label' => 'sidebar-sidebar-content',
		'img'   => $url . 'ssc.gif',
		'type'  => [ 'site' ],
	],
	'sidebar-content-sidebar' => [
		'label' => 'sidebar-content-sidebar',
		'img'   => $url . 'scs.gif',
		'type'  => [ 'site' ],
	],
	'full-width-content'      => [
		'label' => 'full-width-content',
		'img'   => $url . 'c.gif',
		'type'  => [ 'site' ],
	],
];
