<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package Genesis\Admin
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

/**
 * Registers a new admin menu item under "Genesis". Redirects to the plugin install screen filtered to return plugins authored by StudioPress.
 *
 * @since 2.10.0
 */
class Genesis_Admin_Plugins extends Genesis_Admin_Basic {

	/**
	 * Create an admin menu item that redirects to the plugin install screen.
	 *
	 * @since 2.10.0
	 */
	public function __construct() {
		$this->redirect_to = network_admin_url( 'plugin-install.php?s=studiopress&tab=search&type=author' );

		$menu_ops = [
			'submenu' => [
				'parent_slug' => 'genesis',
				'page_title'  => __( 'Genesis Plugins', 'genesis' ),
				'menu_title'  => __( 'Genesis Plugins', 'genesis' ),
			],
		];

		$this->create( 'genesis-plugins', $menu_ops );
	}

	/**
	 * Required to use `Genesis_Admin_Basic`.
	 *
	 * @since 2.10.0
	 */
	public function admin() {}

}
