<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package Genesis\Admin
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

/**
 * The Upgraded page class.
 *
 * @since 1.8.0
 */
class Genesis_Admin_Upgraded extends Genesis_Admin
{

    /**
     * Create the Upgraded page.
     *
     * @since 1.8.0
     */
    public function __construct()
    {

        $page_id = 'genesis-upgraded';

        $menu_ops = array(); // No menu for this page.

        $page_ops = array(
            'basehook' => 'genesis_admin_',
        );

        $this->create($page_id, $menu_ops, $page_ops);

    }

    /**
     * Initialize the settings page.
     *
     * @since 1.8.0
     */
    public function settings_init()
    {
    }

    /**
     * Output the main admin page.
     *
     * @since 1.8.0
     */
    public function admin()
    {

        include GENESIS_VIEWS_DIR . '/pages/genesis-admin-upgraded.php';

    }

}
