<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

/**
 * Class Genesis_Requirements_Views
 *
 * Utility class for handling messaging in various
 * view contexts when system requirements are not met.
 *
 * For internal use only. The existence of public methods
 * does not mean we consider this is a public API. It could
 * change at any time. Developers, do not use this in your code.
 *
 * @private
 * @since 2.7
 */
final class Genesis_Requirements_Views {

	/**
	 * Messages to be shown when requirements not met.
	 *
	 * @var array
	 */
	private $messages;

	/**
	 * Genesis_Requirements_Views constructor.
	 *
	 * @param array $messages Messages to show when requirements not met.
	 */
	public function __construct( array $messages ) {
		$this->messages = $messages;
	}

	/**
	 * Adds necessary hooks for displaying requirements messaging.
	 */
	public function add_hooks() {
		add_action( 'admin_notices', [ $this, 'admin_notice' ] );
	}

	/**
	 * Displays an admin notice when requirements are not met.
	 */
	public function admin_notice() {
		echo '<div class="error">';
		echo wp_kses_post( $this->messages() );
		echo '</div>';
	}

	/**
	 * Formats the messages into paragraphs for display.
	 *
	 * @return string
	 */
	private function messages() {
		$formatted = '';

		foreach ( $this->messages as $message ) {
			$formatted .= '<p>' . $message . '</p>';
		}

		return $formatted;
	}
}
