<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

?>
<div class="pack-info" id="<?php echo esc_attr( 'pack-details-' . $pack_slug ); ?>">
	<div class="pack-info-wrap">
		<div class="pack-info-screenshot">
			<?php echo $pack_image; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- image attributes escaped in `genesis_onboarding_starter_packs_list()`. ?>
		</div>
		<div class="pack-info-details">
			<h2 class="pack-info-name">
				<?php echo esc_html( $pack['title'] ); ?>
			</h2>

			<?php if ( isset( $pack['description'] ) ) : ?>
			<p><?php echo esc_html( $pack['description'] ); ?></p>
			<?php endif; ?>

			<div class="pack-info-actions">
				<button class="button-primary genesis-install-pack" data-pack="<?php echo esc_attr( $pack_slug ); ?>" aria-label="<?php echo esc_attr( $pack_install_label ); ?>">Install Pack</button>

				<?php if ( isset( $pack['demo_url'] ) ) : ?>
				<a class="button button-secondary" aria-label="<?php echo esc_attr( $pack_demo_label ); ?>" href="<?php echo esc_url( $pack['demo_url'] ); ?>" target="_blank" rel="noopener noreferrer">View Demo</a>
				<?php endif; ?>
			</div>

			<?php echo wp_kses_post( genesis_onboarding_plugins_list( $pack_slug ) ); ?>
			<?php echo wp_kses_post( genesis_onboarding_content_list( $pack_slug ) ); ?>

		</div>
	</div>
</div>
